<?php

class GCgraph {
    var $img;
    var $largeur;
    var $hauteur;
    var $couleurs;
    var $nbcouleurs;
    var $donnees;
    var $type;
    var $centrex;
    var $hx;
    var $centrey;
    var $hy;
    var $rayon;
    var $ecartement;
    var $start;
    var $legendex;
    var $legendey;
    var $legendefont;
    var $legendesize;
    var $legendecadre;
    var $legendecolor;
    var $lang;
    var $mode;
    var $repfont;
    var $repsize;

    function GCgraph($x, $y, $tablang)
    {
        $this->lang = $tablang;
        $this->img = imagecreate($x, $y);
        $this->largeur = $x;
        $this->hauteur = $y;
        $this->GCcolorAdd(255, 255, 255);
        $this->GCcolorAdd(0, 0, 0);
        $this->GCcreatePalette();
        // ImageFilledRectangle($this->img,0,0,$x,$y,$this->couleurs[2]);
    } 

    function GCcolorAdd($red, $green, $blue)
    {
        $this->nbcouleurs++;
        $this->couleurs[] = ImageColorAllocate($this->img, $red, $green, $blue);
    } 

    function GCcreateSample()
    {
        $larg = 0;
        $haut = 0;
        for ($i = 0;$i < $this->nbcouleurs;$i++) {
            imagefilledrectangle($this->img, $larg, $haut, $larg + 10, $haut + 10, $this->couleurs[$i]);
            $larg = $larg + 10;
            if ($larg >= 140) {
                $haut = $haut + 10;
                $larg = 20;
            } 
        } 
    } 

    function GCcreatePalette()
    {
        for ($i = 0;$i <= 256;$i = $i + 43) {
            for ($j = 0;$j <= 256;$j = $j + 43) {
                for ($k = 0;$k <= 256;$k = $k + 43) {
                    $this->GCcolorAdd($i, $j, $k);
                } 
            } 
        } 
    } 

    function GCcadre($epaisseur, $couleur = 1)
    {
        for ($i = 0;$i < $epaisseur;$i++) {
            imagerectangle($this->img, $i, $i, $this->largeur - ($i + 1), $this->hauteur - ($i + 1), $this->couleurs[$couleur]);
        } 
    } 

    function GCtitre($titre, $font, $size = 8, $marge = 0, $hauteur, $color = 1, $angle = 0)
    {
        imagettftext($this->img, $size, $angle, $marge, $hauteur, $this->couleurs[$color], getcwd() . "/../deco/ttf/" . $font, $titre);
    } 

    function GCsetDonnees($tab, $color = 1)
    {
        $this->donnees[$color] = $tab;
    } 

    function GCsetCamembert($x, $y, $r, $e = 0, $angle_depart = 0, $legx = 0, $legy = 0, $legfont = "ARIAL.TTF", $legsize = 10, $legcadre = 0, $legcolor = 1)
    {
        $this->type = "camembert";
        $this->centrex = $x;
        $this->centrey = $y;
        $this->rayon = $r;
        $this->ecartement = $e;
        $this->start = $angle_depart;
        $this->legendex = $legx;
        $this->legendey = $legy;
        $this->legendefont = $legfont;
        $this->legendesize = $legsize;
        $this->legendecadre = $legcadre;
        $this->legendecolor = $legcolor;
    } 

    function GCsetLine($mode, $x, $y, $hx, $hy, $legx = 0, $legy = 0, $legfont = "ARIAL.TTF", $legsize = 10, $legcadre = 0, $legcolor = 1, $repfont = "ARIAL.TTF", $repsize = 8)
    {
        $this->mode = $mode;
        $this->type = "ligne";
        $this->centrex = $x;
        $this->centrey = $y;
        $this->hx = $hx;
        $this->hy = $hy;
        $this->start = $angle_depart;
        $this->legendex = $legx;
        $this->legendey = $legy;
        $this->legendefont = $legfont;
        $this->legendesize = $legsize;
        $this->legendecadre = $legcadre;
        $this->legendecolor = $legcolor;
        $this->repfont = $repfont;
        $this->repsize = $repsize;
    } 

    function GCtrace($flag_leg = 1)
    {
        if ($this->type == "camembert")
            $this->GCtraceCamembert();
        elseif ($this->type == "ligne")
            $this->GCtraceLine($flag_leg);
    } 

    function GCtraceLine($flag_leg)
	    {
        foreach ($this->donnees as $tab) 
			{
            foreach ($tab as $val) 
				{
                $max = (($max < $val) || !isset($max)) ? $val : $max;
                $min = (($min > $val) || !isset($min)) ? $val : $min;
            	} 
			$nbr=sizeof($tab);
        	} 

	
		$amp=$max-$min;
		if ($amp==0) $amp=1;
        $coef = ($this->hy-2) / ($amp); 
        // on trace le repre
	        imageline($this->img, $this->centrex, $this->centrey + 2, $this->centrex, $this->centrey - $this->hy, $this->couleurs[1]);

        if ($min >= 0)
            imageline($this->img, $this->centrex-2, $this->centrey, $this->centrex + $this->hx, $this->centrey, $this->couleurs[1]);

        if (($min < 0) && ($max>0)) {
            imageline($this->img, $this->centrex-2, $this->centrey + ($min * $coef), $this->centrex + $this->hx, $this->centrey + ($min * $coef), $this->couleurs[1]);
            imagettfText($this->img, $this->repsize, 0, $this->centrex - $this->repsize * 0.5 - $this->repsize * 0.8 * strlen("0"), $this->centrey + ($min * $coef) + $this->repsize / 2, $this->couleurs[1], getcwd() . "/../deco/ttf/" . $this->repfont, "0");
			}
			
        for ($i = $this->centrex-2;$i < $this->centrex + $this->hx;$i = $i + 10)
	        imageline($this->img, $i, $this->centrey, $i + 5, $this->centrey, $this->couleurs[1]);
        for ($i = $this->centrex-2;$i < $this->centrex + $this->hx;$i = $i + 10)
	        imageline($this->img, $i, $this->centrey-(($amp)*$coef), $i + 5, $this->centrey-(($amp)*$coef), $this->couleurs[1]);
        

        imagettfText($this->img, $this->repsize, 0, $this->centrex - $this->repsize * 0.5 - $this->repsize * 0.8 * strlen($min), $this->centrey + $this->repsize / 2, $this->couleurs[1], getcwd() . "/../deco/ttf/" . $this->repfont, $min);
        imagettfText($this->img, $this->repsize, 0, $this->centrex - $this->repsize * 0.5 - $this->repsize * 0.8 * strlen($max), $this->centrey - $this->hy + $this->repsize / 2, $this->couleurs[1], getcwd() . "/../deco/ttf/" . $this->repfont, $max);
	    
		$step=$this->hx/$nbr;
		$n=0;
        foreach ($this->donnees as $k=>$tab) 
			{
			$n++;
			$px=0;
			$ex_px=0;
            foreach ($tab as $val) 
				{
				if (!isset($ex_val)) $ex_val=$val;
				Imageline($this->img,$this->centrex+$px,$this->centrey-(($val-$min)*$coef),$this->centrex+$ex_px,$this->centrey-(($ex_val-$min)*$coef),$this->couleurs[$n*4]);
				$ex_px=$px;
				$ex_val=$val;
				$px=$px+$step;
				} 
				
			if ($flag_leg==1)
				{
	            ImageFilledRectangle($this->img, $this->legendex, $this->legendey - $this->legendesize, $this->legendex + $this->legendesize, $this->legendey, $this->couleurs[$i * 4]);
    	        imagettftext($this->img, $this->legendesize, 0, $this->legendex + $this->legendesize * 1.5, $this->legendey, $this->couleurs[$this->legendecolor], getcwd() . "/../deco/ttf/" . $this->legendefont, $k . " " . $val);
        	    $this->legendey = $this->legendey + $this->legendesize * 1.5;
				}

        	} 
		
		reset($this->donnees);
		$range=pos($this->donnees);
		$px=0;
		$n=0;
		$step_rep=intval($nbr/20);
		foreach ($range as $k => $v)
			{
			if ($n==0)
	   	        imagettftext($this->img, $this->repsize, 90, $this->centrex + $px+$this->repsize/2, $this->centrey+strlen($k)*$this->repsize*0.8, $this->couleurs[$this->legendecolor], getcwd() . "/../deco/ttf/" . $this->repfont, $k);
			$n++;
			if ($n==$step_rep) $n=0;
			$px=$px+$step;
			}
		
		} 

    function GCtraceCamembert()
	    { 
        // traage des portions
        $i = 1;
        foreach ($this->donnees[1] as $val) 
			{
            $max = ($max < $val) ? $val : $max;
            $som = $som + $val;
        	} 

        foreach ($this->donnees[1] as $key => $val) 
			{
            if ($val / $som < 0.05)
                $nouv[$this->lang["autres"]] = $nouv[$this->lang["autres"]] + $val;
            else
                $nouv[$key] = $val;
	        } 
        $this->donnees[1] = $nouv;

        $deb = $this->start;
        foreach ($this->donnees[1] as $val) 
			{
            $fin = $deb + ($val / $som) * 360; 
            // print $deb." ".$fin." ".($this->ecartement*cos(($deb+$fin)/2))." ".($this->ecartement*sin(($deb+$fin)/2))."<br>";
            imagefilledarc($this->img, $this->centrex + ($this->ecartement * cos(deg2rad(($deb + $fin) / 2))), $this->centrey + ($this->ecartement * sin(deg2rad(($deb + $fin) / 2))), $this->rayon, $this->rayon, $deb, $fin, $this->couleurs[$i * 4], 0);
            $deb = $fin;
            $i++;
        	} 
        // ecriture de la lgende
        $i = 0;
        foreach ($this->donnees[1] as $key => $val) 
			{
            $i++;
            ImageFilledRectangle($this->img, $this->legendex, $this->legendey - $this->legendesize, $this->legendex + $this->legendesize, $this->legendey, $this->couleurs[$i * 4]);
            imagettftext($this->img, $this->legendesize, 0, $this->legendex + $this->legendesize * 1.5, $this->legendey, $this->couleurs[$this->legendecolor], getcwd() . "/../deco/ttf/" . $this->legendefont, $key . " " . $val);
            $this->legendey = $this->legendey + $this->legendesize * 1.5;
        	} 
    	} 

    function GCrender()
    	{
        /**
         * if (function_exists("imagegif")) 
         * {
         * header("Content-type: image/gif");
         * imagegif($this->img);
         * }
         * elseif
         */
        if (function_exists("imageJpeg")) {
            header("Content-type: image/jpeg");
            imagejpeg($this->img, "", 100);
        } elseif (function_exists("imagePng")) {
            header("Content-type: image/png");
            imagepng($this->img);
        } elseif (function_exists("imagewbmp")) {
            header("Content-type: image/vnd.wap.wbmp");
            imagewbmp($this->img);
        } else {
            die($lang["nosuppgraphphp"]);
        } 
    } 
} 

?>